import { NextResponse } from 'next/server';
import fs from 'fs';
import path from 'path';

export async function GET() {
    const sequenceDir = path.join(process.cwd(), 'public', 'hero-sequence');

    try {
        // Check if directory exists
        if (!fs.existsSync(sequenceDir)) {
            console.warn('Hero sequence directory not found:', sequenceDir);
            return NextResponse.json({ count: 0, frames: [] });
        }

        // Read files
        const files = fs.readdirSync(sequenceDir);

        // Filter for image files (jpg, jpeg, png, webp)
        // and sort them alphanumerically to ensure correct sequence order
        const frames = files
            .filter((file) => /\.(jpg|jpeg|png|webp)$/i.test(file))
            .sort((a, b) => a.localeCompare(b, undefined, { numeric: true, sensitivity: 'base' }))
            .map((file) => `/hero-sequence/${file}`);

        return NextResponse.json({
            count: frames.length,
            frames: frames,
        });
    } catch (error) {
        console.error('Error reading hero sequence:', error);
        return NextResponse.json({ count: 0, frames: [] }, { status: 500 });
    }
}
