import type { Metadata } from "next";
import "../styles/globals.css";
import Providers from "@/components/Providers";

export const metadata: Metadata = {
  title: "Sanvya Technologies",
  description: "We build digital infrastructure that feels invisible. Systems designed for clarity, not complexity.",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body>
        <Providers>
          {children}
        </Providers>
      </body>
    </html>
  );
}
