"use client";

import Hero from "@/components/Hero";
import Section from "@/components/Section";
import EndingSection from "@/components/EndingSection";
import Navbar from "@/components/Navbar";
import IconRibbon from "@/components/IconRibbon";
import VideoSection from "@/components/VideoSection";
import IndustrySolutions from "@/components/IndustrySolutions";
import Services from "@/components/Services";
import Testimonials from "@/components/Testimonials";
import GridBackground from "@/components/GridBackground";

export default function Home() {
  return (
    <main style={{ background: "var(--bg-page)", minHeight: "100vh", position: "relative" }}>
      {/* Grid Background - Feathered edges */}
      <GridBackground />

      {/* NAVBAR - Glassmorphism with subtle scroll behavior */}
      <Navbar />

      {/* 1. HERO - Massive headline, minimal subline, primary CTA */}
      <Hero />

      {/* 2. CONTEXTUAL VIDEO BACKGROUND - Large visual anchor with scroll animation */}
      <div style={{ position: "relative", zIndex: 1 }}>
        <VideoSection aspectRatio="21/9" videoUrl="/SanvyaTech2.mp4" />
      </div>

      {/* ICON RIBBON - Animated infinite scroll */}
      <div style={{ position: "relative", zIndex: 1 }}>
        <IconRibbon />
      </div>

      {/* 3. EDITORIAL STATEMENT - Large sentence in a card */}
      <section className="section" style={{ position: "relative", zIndex: 1, paddingTop: "var(--space-5xl)", paddingBottom: "var(--space-5xl)" }}>
        <div className="container" style={{ maxWidth: "900px" }}>
          <div
            className="editorial-card animated-gradient-card"
            style={{
              borderRadius: "var(--radius-lg)",
              padding: "var(--space-4xl)",
              position: "relative",
              overflow: "hidden",
              textAlign: "center",
            }}
          >
            {/* Corner Borders */}
            <div className="corner-borders"></div>

            <h2
              className="heading-xl"
              style={{
                margin: "0 auto",
                maxWidth: "20ch",
              }}
            >
              We <strong>build systems</strong> that <strong>respect</strong> your <strong>intelligence</strong>.
            </h2>
          </div>
        </div>

        {/* Corner Border Styles */}
        <style jsx>{`
          .corner-borders::before,
          .corner-borders::after {
            content: "";
            position: absolute;
            width: 50px;
            height: 50px;
            border: 2px solid #171717;
          }

          /* Top-left corner */
          .corner-borders::before {
            top: 0;
            left: 0;
            border-right: none;
            border-bottom: none;
            border-top-left-radius: var(--radius-lg);
          }

          /* Bottom-right corner */
          .corner-borders::after {
            bottom: 0;
            right: 0;
            border-left: none;
            border-top: none;
            border-bottom-right-radius: var(--radius-lg);
          }

          .editorial-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
          }

          .editorial-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 32px rgba(0, 0, 0, 0.08);
          }

          @media (max-width: 767px) {
            .corner-borders::before,
            .corner-borders::after {
              width: 30px;
              height: 30px;
            }
          }
        `}</style>
      </section>



      {/* ABOUT SECTION */}
      <section id="about" className="section" style={{ position: "relative", zIndex: 1, paddingTop: "var(--space-5xl)", paddingBottom: "var(--space-5xl)" }}>
        <div className="container">
          <div
            className="about-card animated-gradient-card"
            style={{
              borderRadius: "var(--radius-lg)",
              padding: "var(--space-4xl)",
              position: "relative",
              overflow: "hidden",
            }}
          >
            {/* Corner Borders */}
            <div className="corner-borders"></div>

            <div className="about-grid" style={{ display: "grid", gridTemplateColumns: "1fr 1fr", gap: "var(--space-4xl)", alignItems: "center" }}>
              <div>
                <h2 className="heading-xl" style={{ marginBottom: "var(--space-xl)" }}>
                  About Sanvya
                </h2>
                <p className="body-lg" style={{ marginBottom: "var(--space-lg)", opacity: 0.85 }}>
                  We are a team of designers, engineers, and strategists who believe technology should enhance human capability, not complicate it.
                </p>
                <p className="body-lg" style={{ opacity: 0.85 }}>
                  Our approach is simple: understand the problem deeply, design with intention, and build with precision. We create systems that feel invisible because they just work.
                </p>
              </div>
              <div className="media-container aspect-4-3" style={{ borderRadius: "var(--radius-md)", overflow: "hidden" }}>
                <video
                  autoPlay
                  muted
                  loop
                  playsInline
                  src="/team-video.mp4"
                  style={{ width: "100%", height: "100%", objectFit: "cover" }}
                />
              </div>
            </div>
          </div>
        </div>

        {/* Corner Border Styles */}
        <style jsx>{`
          .corner-borders::before,
          .corner-borders::after {
            content: "";
            position: absolute;
            width: 50px;
            height: 50px;
            border: 2px solid #171717;
          }

          /* Top-left corner */
          .corner-borders::before {
            top: 0;
            left: 0;
            border-right: none;
            border-bottom: none;
            border-top-left-radius: var(--radius-lg);
          }

          /* Bottom-right corner */
          .corner-borders::after {
            bottom: 0;
            right: 0;
            border-left: none;
            border-top: none;
            border-bottom-right-radius: var(--radius-lg);
          }

          .about-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
          }

          .about-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 32px rgba(0, 0, 0, 0.08);
          }

          @media (max-width: 767px) {
            .about-grid {
              grid-template-columns: 1fr !important;
              gap: var(--space-2xl) !important;
            }

            .corner-borders::before,
            .corner-borders::after {
              width: 30px;
              height: 30px;
            }
          }
        `}</style>
      </section>

      {/* INDUSTRY SOLUTIONS SECTION */}
      <div style={{ position: "relative", zIndex: 1 }}>
        <IndustrySolutions />
      </div>

      {/* SERVICES SECTION */}
      <div style={{ position: "relative", zIndex: 1 }}>
        <Services />
      </div>

      {/* TESTIMONIALS SECTION */}
      <div style={{ position: "relative", zIndex: 1 }}>
        <Testimonials />
      </div>

      {/* 6. FINAL MEDIA FEATURE - Large visual anchor */}
      <div style={{ position: "relative", zIndex: 1 }}>
        <VideoSection aspectRatio="21/9" videoUrl="/SanvyaTech1.mp4" />
      </div>

      {/* ANTIGRAVITY-STYLE ENDING SECTION */}
      <div style={{ position: "relative", zIndex: 1 }}>
        <EndingSection />
      </div>
    </main >
  );
}

